import time
import sys

def quickSort(array):
    if len(array) <= 1:
        return array
    else:
        pivot = array[0]
        less = [x for x in array[1:] if x <= pivot]
        greater = [x for x in array[1:] if x > pivot]
        return quickSort(less) + [pivot] + quickSort(greater)

# Meminta input deret dari pengguna
input_str = input("Masukkan deret angka, dipisahkan oleh spasi: ")
input_list = input_str.split()
array = [int(x) for x in input_list]

# Memulai hitung waktu eksekusi
start_time = time.time()

# Memanggil fungsi quickSort
sorted_array = quickSort(array)

# Menghitung waktu eksekusi
elapsed_time = time.time() - start_time

# Menampilkan hasil pengurutan dan waktu eksekusi
print("Hasil pengurutan: ", end="")
for val in sorted_array:
    print(val, end=" ")
print()

# Menampilkan pemakaian ruang memori dalam byte
size = sys.getsizeof(sorted_array)
print("Pemakaian ruang memori: ", size, "byte")

print("Waktu eksekusi:", elapsed_time, "detik")